/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.entity.pumpkinwarden;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PumpkinWarden
extends PathfinderMob
implements GeoEntity {
    private final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private BlockPos jukebox;
    private boolean party;
    private static final EntityDataAccessor<Boolean> HIDING = SynchedEntityData.m_135353_(PumpkinWarden.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TIMER = SynchedEntityData.m_135353_(PumpkinWarden.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<BlockState> DATA_CARRY_STATE = SynchedEntityData.m_135353_(PumpkinWarden.class, (EntityDataSerializer)EntityDataSerializers.f_135034_);
    public Goal moveGoal = new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.7f);
    public Goal runGoal = new AvoidEntityGoal((PathfinderMob)this, Zombie.class, 8.0f, 1.0, 1.0);
    public Goal lookGoal = new LookAtPlayerGoal((Mob)this, Player.class, 2.0f);
    public Goal randLookGoal = new RandomLookAroundGoal((Mob)this);
    private static final RawAnimation HIDE_START = RawAnimation.begin().thenPlay("animation.pumpkinwarden.hidestart");
    private static final RawAnimation HIDE = RawAnimation.begin().thenPlay("animation.pumpkinwarden.hide");
    private static final RawAnimation HIDE_END = RawAnimation.begin().thenPlay("animation.pumpkinwarden.hideend");
    private static final RawAnimation HOLDING_WALKING = RawAnimation.begin().thenPlay("animation.pumpkinwarden.holding_walking");
    private static final RawAnimation HOLDING_IDLE = RawAnimation.begin().thenPlay("animation.pumpkinwarden.holding_idle");
    private static final RawAnimation WALKING = RawAnimation.begin().thenPlay("animation.pumpkinwarden.walking");
    private static final RawAnimation IDLE = RawAnimation.begin().thenPlay("animation.pumpkinwarden.idle");
    private static final RawAnimation WAVE = RawAnimation.begin().thenPlay("animation.pumpkinwarden.wave");

    public PumpkinWarden(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CARRY_STATE, (Object)Blocks.f_50016_.m_49966_());
        this.f_19804_.m_135372_(HIDING, (Object)false);
        this.f_19804_.m_135372_(TIMER, (Object)0);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.4);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(9, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42687_}), false));
        this.f_21345_.m_25352_(2, (Goal)new ThrowItemAtCarvedPumpkinGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new DestroyNearestPumpkinGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new StayByBellGoal(this, 1.0, 5000));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public void m_6043_() {
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    private <E extends GeoAnimatable> PlayState predicate(@NotNull AnimationState<E> event) {
        AnimationController controller = event.getController();
        controller.transitionLength(0);
        if (this.isHiding()) {
            if (this.getTimer() < 10) {
                controller.setAnimation(HIDE_START);
                return PlayState.CONTINUE;
            }
            if (this.getTimer() > 10 && this.getTimer() < 180 || !this.m_9236_().m_46461_() && this.getTimer() > 10) {
                controller.setAnimation(HIDE);
                return PlayState.CONTINUE;
            }
            if (this.getTimer() > 180) {
                if (this.m_9236_().m_45517_(LightLayer.SKY, this.m_20097_()) > 2) {
                    controller.setAnimation(HIDE_END);
                } else {
                    controller.setAnimation(HIDE);
                }
                return PlayState.CONTINUE;
            }
        }
        if (this.getCarriedBlock() != null) {
            if (event.isMoving()) {
                controller.setAnimation(HOLDING_WALKING);
            } else {
                controller.setAnimation(HOLDING_IDLE);
            }
            return PlayState.CONTINUE;
        }
        if (event.isMoving() && this.getCarriedBlock() == null) {
            controller.setAnimation(WALKING);
            return PlayState.CONTINUE;
        }
        if (this.party) {
            controller.setAnimation(WAVE);
            return PlayState.CONTINUE;
        }
        controller.setAnimation(IDLE);
        return PlayState.CONTINUE;
    }

    public void checkGoals() {
        if (this.f_21345_.m_148105_().stream().noneMatch(goal -> goal.m_26015_().getClass() == WaterAvoidingRandomStrollGoal.class)) {
            this.f_21345_.m_25352_(1, this.moveGoal);
        }
        if (this.f_21345_.m_148105_().stream().noneMatch(goal -> goal.m_26015_().getClass() == AvoidEntityGoal.class)) {
            this.f_21345_.m_25352_(2, this.runGoal);
        }
        if (this.f_21345_.m_148105_().stream().noneMatch(goal -> goal.m_26015_().getClass() == LookAtPlayerGoal.class)) {
            this.f_21345_.m_25352_(7, this.lookGoal);
        }
        if (this.f_21345_.m_148105_().stream().noneMatch(goal -> goal.m_26015_().getClass() == RandomLookAroundGoal.class)) {
            this.f_21345_.m_25352_(3, this.randLookGoal);
        }
    }

    public void m_6818_(@NotNull BlockPos pPos, boolean pIsPartying) {
        this.jukebox = pPos;
        this.party = pIsPartying;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.jukebox == null || !this.jukebox.m_203195_((Position)this.m_20182_(), 10.0) || !this.m_9236_().m_8055_(this.jukebox).m_60713_(Blocks.f_50131_)) {
            this.party = false;
            this.jukebox = null;
        }
        if (!this.m_9236_().m_5776_()) {
            if (!this.m_9236_().m_46461_()) {
                this.setTimer(this.getTimer() + 1);
                this.setHiding(true);
            } else if (this.getTimer() > 0 && this.m_21188_() == null) {
                this.setTimer(0);
                this.setHiding(false);
            }
            if (this.m_21188_() != null) {
                if (this.getTimer() < 200) {
                    this.setTimer(this.getTimer() + 1);
                    this.setHiding(true);
                } else {
                    this.setTimer(0);
                    this.setHiding(false);
                }
            }
        }
        if (this.isHiding()) {
            this.f_21345_.m_25363_(this.moveGoal);
            this.f_21345_.m_25363_(this.runGoal);
            this.f_21345_.m_25363_(this.lookGoal);
            this.f_21345_.m_25363_(this.randLookGoal);
            if (this.getCarriedBlock() != null) {
                BehaviorUtils.m_22613_((LivingEntity)this, (ItemStack)this.getCarriedBlock().m_60734_().m_5456_().m_7968_(), (Vec3)new Vec3(this.m_20185_() + 2.0, this.m_20186_(), this.m_20189_()));
                this.setCarriedBlock(null);
            }
        } else {
            this.checkGoals();
        }
        if (this.getCarriedBlock() != null) {
            this.m_21008_(this.m_7655_(), this.getCarriedBlock().m_60734_().m_5456_().m_7968_());
        } else {
            this.m_21008_(this.m_7655_(), ItemStack.f_41583_);
        }
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pose) {
        if (this.isHiding()) {
            return this.m_6095_().m_20680_().m_20390_(1.0f, 0.5f);
        }
        return super.m_6972_(pose);
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_6210_();
    }

    public boolean m_6573_(@NotNull Player player) {
        return true;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12503_;
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return SoundEvents.f_12506_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12505_;
    }

    public float m_6100_() {
        return (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.5f;
    }

    public boolean isHiding() {
        return (Boolean)this.f_19804_.m_135370_(HIDING);
    }

    public void setHiding(boolean flag) {
        this.f_19804_.m_135381_(HIDING, (Object)flag);
    }

    public int getTimer() {
        return (Integer)this.f_19804_.m_135370_(TIMER);
    }

    public void setTimer(int flag) {
        this.f_19804_.m_135381_(TIMER, (Object)flag);
    }

    public void setCarriedBlock(BlockState pState) {
        this.f_19804_.m_135381_(DATA_CARRY_STATE, (Object)(pState == null ? Blocks.f_50016_.m_49966_() : pState));
    }

    public BlockState getCarriedBlock() {
        BlockState blockState = (BlockState)this.f_19804_.m_135370_(DATA_CARRY_STATE);
        return blockState.m_60795_() ? null : blockState;
    }

    private static class ThrowItemAtCarvedPumpkinGoal
    extends MoveToBlockGoal {
        private final PumpkinWarden warden;

        private ThrowItemAtCarvedPumpkinGoal(PumpkinWarden mob, double speed) {
            super((PathfinderMob)mob, speed, 32);
            this.warden = mob;
        }

        protected boolean m_6465_(LevelReader level, BlockPos pos) {
            return level.m_8055_(pos).m_60713_(Blocks.f_50143_);
        }

        public boolean m_8036_() {
            return this.m_25626_() && this.warden.getCarriedBlock() != null;
        }

        public void m_8037_() {
            Level level;
            BlockState state;
            super.m_8037_();
            if (this.m_25625_() && (state = (level = this.f_25598_.m_9236_()).m_8055_(this.f_25602_)).m_60713_(Blocks.f_50143_)) {
                Direction facing = (Direction)state.m_61143_((Property)CarvedPumpkinBlock.f_51367_);
                BlockPos frontPos = this.f_25602_.m_121945_(facing);
                if (this.f_25598_.m_20183_().m_123314_((Vec3i)frontPos, 2.5) && this.warden.getCarriedBlock() != null) {
                    BehaviorUtils.m_22613_((LivingEntity)this.warden, (ItemStack)this.warden.getCarriedBlock().m_60734_().m_5456_().m_7968_(), (Vec3)new Vec3((double)this.f_25602_.m_123341_(), (double)this.f_25602_.m_123342_(), (double)this.f_25602_.m_123343_()));
                    this.warden.setCarriedBlock(null);
                }
            }
        }
    }

    private static class DestroyNearestPumpkinGoal
    extends MoveToBlockGoal {
        private final PumpkinWarden warden;

        private DestroyNearestPumpkinGoal(PumpkinWarden mob, double speed) {
            super((PathfinderMob)mob, speed, 32);
            this.warden = mob;
        }

        protected boolean m_6465_(LevelReader level, BlockPos pos) {
            return level.m_8055_(pos).m_60713_(Blocks.f_50133_) || level.m_8055_(pos).m_60713_(Blocks.f_50186_);
        }

        public boolean m_8036_() {
            return this.m_25626_() && this.warden.getCarriedBlock() == null;
        }

        public void m_8037_() {
            Level level;
            super.m_8037_();
            if (this.m_25625_() && this.m_6465_((LevelReader)(level = this.f_25598_.m_9236_()), this.f_25602_)) {
                BlockState blockstate = level.m_8055_(this.f_25602_);
                level.m_46953_(this.f_25602_, false, (Entity)this.f_25598_);
                level.m_220407_(GameEvent.f_157794_, this.f_25602_, GameEvent.Context.m_223719_((Entity)this.warden, (BlockState)blockstate));
                this.warden.setCarriedBlock(blockstate.m_60734_().m_49966_());
            }
        }
    }

    private static class StayByBellGoal
    extends MoveToBlockGoal {
        private final PumpkinWarden warden;

        private StayByBellGoal(PumpkinWarden pumpkinWarden, double speedModifier, int searchRange) {
            super((PathfinderMob)pumpkinWarden, speedModifier, searchRange);
            this.warden = pumpkinWarden;
        }

        protected boolean m_6465_(LevelReader level, @NotNull BlockPos pos) {
            List blockStates = level.m_45556_(new AABB(this.warden.m_20183_()).m_82400_(30.0)).toList();
            return !((BlockState)blockStates.get(this.warden.f_19796_.m_188503_(blockStates.size()))).m_60795_();
        }
    }
}

